<div class="tab-pane fade" id="paypal_payment_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.update-paypal')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for=""><?php echo e(__('Account Mode')); ?></label>
                    <select name="paypal_account_mode" id="paypal_account_mode" class="form-control">
                        <option <?php echo e($basic_payment->paypal_account_mode == 'live' ? 'selected' : ''); ?> value="live">
                            <?php echo e(__('Live')); ?></option>
                        <option <?php echo e($basic_payment->paypal_account_mode == 'sandbox' ? 'selected' : ''); ?>

                            value="sandbox"><?php echo e(__('Sandbox')); ?></option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="form-group">
                    <label for=""><?php echo e(__('Gateway charge (%)')); ?></label>
                    <input type="text" class="form-control" name="paypal_charge"
                        value="<?php echo e($basic_payment->paypal_charge); ?>">
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group">
                    <label for=""><?php echo e(__('App Id')); ?></label>
                        <input type="text" class="form-control" name="paypal_app_id"
                            value="<?php echo e($basic_payment->paypal_app_id); ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for=""><?php echo e(__('Client Id')); ?></label>
                    <?php if(env('APP_MODE') == 'DEMO'): ?>
                        <input type="text" class="form-control" name="paypal_client_id"
                            value="PAYPAL-TEST-CLIENT98934343-343-ID">
                    <?php else: ?>
                        <input type="text" class="form-control" name="paypal_client_id"
                            value="<?php echo e($basic_payment->paypal_client_id); ?>">
                    <?php endif; ?>

                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label for=""><?php echo e(__('Secret Key')); ?></label>
                    <?php if(env('APP_MODE') == 'DEMO'): ?>
                        <input type="text" class="form-control" name="paypal_secret_key"
                            value="PAYPAL-TEST-398439483-SECRET-KEY">
                    <?php else: ?>
                        <input type="text" class="form-control" name="paypal_secret_key"
                            value="<?php echo e($basic_payment->paypal_secret_key); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="form-group">
            <label><?php echo e(__('New Image')); ?> <code>(<?php echo e(__('Recommended')); ?>: 210X100 PX)</code></label>
            <div id="image-preview-paypal" class="image-preview">
                <label for="image-upload-paypal"
                    id="image-label-paypal"><?php echo e(__('Image')); ?></label>
                <input type="file" name="paypal_image" id="image-upload-paypal">
            </div>
        </div>
        <div class="form-group">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="paypal_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="paypal_status" class="custom-switch-input"
                    <?php echo e($basic_payment?->paypal_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
            </label>
        </div>

        <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\sections\paypal.blade.php ENDPATH**/ ?>