<?php
    $cryptoCredentials = (object) Modules\CryptoPayment\app\Models\CryptoPG::pluck('value', 'key')->toArray();
?>
<div class="tab-pane fade" id="coingate_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.cryptopayment.update', 1)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="row">

            <div class="form-group col-md-6">
                <label><?php echo e(__('Sandbox Status')); ?> <span class="text-danger">*</span></label>
                <select name="crypto_sandbox" class="form-control select2" id="crypto_sandbox">
                    <option value=""><?php echo e(__('Select Sandbox Status')); ?></option>
                    <option value="<?php echo e(config('basicpayment.default_status.active_int')); ?>" <?php if(config('basicpayment.default_status.active_int') == old('crypto_sandbox', @$cryptoCredentials?->crypto_sandbox)): echo 'selected'; endif; ?>>
                        <?php echo e(__('Sandbox')); ?></option>
                    <option value="<?php echo e(config('basicpayment.default_status.inactive_int')); ?>"
                        <?php if(config('basicpayment.default_status.inactive_int') == old('crypto_sandbox', @$cryptoCredentials?->crypto_sandbox)): echo 'selected'; endif; ?>><?php echo e(__('Live')); ?></option>
                </select>
            </div>

            <div class="form-group col-md-6">
                <label for="crypto_token"><?php echo e(__('CoinGate Token')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="crypto_token" id="crypto_token"
                    value="<?php echo e(@$cryptoCredentials?->crypto_token); ?>" required="true"
                    placeholder="<?php echo e(__('CoinGate Token')); ?>">
            </div>

            <div class="form-group col-md-6">
                <label for="crypto_receive_currency"><?php echo e(__('CoinGate Receiving Currency')); ?>

                    <span class="text-danger">*</span></label>
                <?php
                    $currencies = [
                        'BTC' => 'Bitcoin',
                        'EUR' => 'Euro',
                        'USD' => 'US Dollar',
                        'GBP' => 'British Pound',
                        'ETH' => 'Ethereum',
                    ];

                ?>
                <select name="crypto_receive_currency" class="form-control select2" id="crypto_receive_currency">
                    <option value=""><?php echo e(__('Select Receiving Currency')); ?></option>
                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($currency); ?>" <?php if($currency == old('crypto_receive_currency', @$cryptoCredentials?->crypto_receive_currency)): echo 'selected'; endif; ?>>
                            <?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="form-group col-md-6">
                <label for="crypto_charge"><?php echo e(__('Charge')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="crypto_charge" id="crypto_charge"
                    value="<?php echo e(@$cryptoCredentials?->crypto_charge ?? 0); ?>" required="true"
                    placeholder="<?php echo e(__('Charge')); ?>">
            </div>

            <div class="form-group col-md-12">
                <label><?php echo e(__('New Image')); ?></label>
                <div id="image-preview-coingate" class="image-preview"
                    style="background-image: url(<?php echo e(asset(@$cryptoCredentials?->crypto_image ?? 'uploads/website-images/coingate.webp')); ?>);">
                    <label for="image-upload-coingate" id="image-label-coingate"><?php echo e(__('Image')); ?></label>
                    <input type="file" name="crypto_image" id="image-upload-coingate">
                </div>

            </div>

            <div class="form-group col-md-12">
                <label class="d-flex align-items-center">
                    <input type="hidden" value="<?php echo e(config('basicpayment.default_status.inactive_text')); ?>"
                        name="crypto_status" class="custom-switch-input">
                    <input type="checkbox" <?php if(config('basicpayment.default_status.active_text') == old('crypto_status', @$cryptoCredentials?->crypto_status)): echo 'checked'; endif; ?>
                        value="<?php echo e(config('basicpayment.default_status.active_text')); ?>" name="crypto_status"
                        class="custom-switch-input"
                        <?php echo e(@$cryptoCredentials?->crypto_status == 'active' ? 'checked' : ''); ?>>
                    <span class="custom-switch-indicator"></span>
                    <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
                </label>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\sections\coingate.blade.php ENDPATH**/ ?>