<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Lesson Questions')); ?></h4>
        </div>
        <form class="row mb-3 justify-content-end instructor__profile-form"
            action="<?php echo e(route('instructor.lesson-questions.index')); ?>" method="GET" onchange="$(this).trigger('submit')">
            <div class="col-lg-2 col-sm-5 col-md-4">
                <div class="form-grp">
                    <select name="seen" id="seen" class="form-select">
                        <option value=""><?php echo e(__('All')); ?></option>
                        <option value="1" <?php echo e(request('seen') == '1' ? 'selected' : ''); ?>><?php echo e(__('Read')); ?>

                        </option>
                        <option value="0"<?php echo e(request('seen') == '0' ? 'selected' : ''); ?>><?php echo e(__('Unread')); ?>

                        </option>
                    </select>
                </div>
            </div>
            <div class="col-lg-2 col-sm-5 col-md-4">
                <div class="form-grp">
                    <select name="sort_by" id="sort_by" class="form-select">
                        <option value="0" <?php echo e(request('sort_by') == '0' ? 'selected' : ''); ?>><?php echo e(__('Newest ')); ?>

                        </option>
                        <option value="1" <?php echo e(request('sort_by') == '1' ? 'selected' : ''); ?>><?php echo e(__('Oldest ')); ?>

                        </option>
                    </select>
                </div>
            </div>
        </form>
        <div class="row">
            <?php $__empty_1 = true; $__currentLoopData = $lesson_questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-12 mb-5">
                    <div class="d-flex gap-2 align-items-start">
                        <input class="question-view form-check-input" <?php echo e($question?->seen == '0' ? 'checked' : ''); ?>

                            type="checkbox" title="<?php echo e($question?->seen == '0' ? __('Mark as unread') : __('Mark read')); ?>"
                            onchange="markAsReadUnread(this,<?php echo e($question->id); ?>)">

                        <div class="card wsus_lesson_qna_list w-100">
                            <div class="card-header d-flex justify-content-between gap-3">
                                <div class="d-flex align-items-center gap-2">
                                    <img class="wsus_thumbnail" src="<?php echo e(asset($question?->course?->thumbnail)); ?>"
                                        alt="<?php echo e($question?->course?->title); ?>">
                                    <div class="wsus_qna_question_title">
                                        <p><?php echo e(__('Student Question In')); ?> <a target="_blank"
                                                href="<?php echo e(route('student.learning.index', $question?->course?->slug)); ?>"><?php echo e(' ' . $question?->course?->title); ?></a>
                                        </p>
                                        <p><?php echo e(__('Lesson')); ?> <a target="_blank"
                                                href="<?php echo e(route('student.learning.index', ['slug' => $question?->course?->slug, 'lesson' => $question?->lesson_id, 'type' => $question?->lesson?->chapterItem?->type])); ?>"><?php echo e(' ' . $question?->lesson?->title); ?></a>
                                        </p>
                                    </div>
                                </div>
                                <a href="javascript:;" class="delete-item"><i class="fas fa-trash-alt text-danger"></i>
                                    <form action="<?php echo e(route('instructor.lesson-question.destroy', $question->id)); ?>"
                                        method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                </a>
                            </div>
                            <div class="card-body">
                                <div class="wsus_qna_question">
                                    <div class="d-flex align-items-center gap-2">
                                        <img class="wsus_thumbnail" src="<?php echo e(asset($question?->user?->image)); ?>"
                                            alt="<?php echo e($question?->user?->name); ?>">
                                        <div class="d-flex flex-column">
                                            <a href="javascript:;"><?php echo e($question?->user?->name); ?></a>
                                            <span><?php echo e(formatDate($question?->created_at, 'd M, Y : H:i')); ?></span>
                                        </div>
                                    </div>
                                    <div class="mt-3 wsus_qna_reply">
                                        <a href="javascript:;"><?php echo e($question?->question_title); ?></a>
                                        <?php echo clean(replaceImageSources($question?->question_description)); ?>

                                    </div>
                                </div>
                                <h6 class="text-center wsus_qna_reply_count">( <?php echo e($question->replies_count); ?>

                                    <?php echo e(__('answers')); ?> )</h6>
                                <?php $__empty_2 = true; $__currentLoopData = $question?->replies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                    <div class="wsus_qna_reply_item">
                                        <div
                                            class="wsus_reply_header  d-flex justify-content-between gap-3 align-items-start">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="wsus_thumbnail rounded-circle">
                                                    <img src="<?php echo e(asset($reply?->user?->image)); ?>" alt="img">
                                                </div>
                                                <div class="d-flex flex-column">
                                                    <a href="javascript:;"><?php echo e($reply?->user?->name); ?></a>
                                                    <span><?php echo e(formatDate($reply?->created_at, 'd M, Y : H:i')); ?></span>
                                                </div>
                                            </div>
                                            <a href="javascript:;" class="delete-item"><i
                                                    class="fas fa-trash-alt text-danger"></i>
                                                <form action="<?php echo e(route('instructor.lesson-reply.destroy', $reply?->id)); ?>"
                                                    method="POST" class="d-none">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                </form>
                                            </a>
                                        </div>
                                        <div class="wsus_reply_content">
                                            <?php echo clean(replaceImageSources($reply?->reply)); ?>

                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                    <p class="text-center ps-5"><?php echo e(__('No replies yet')); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="card-footer footer_input p-0">
                                <form action="<?php echo e(route('instructor.lesson-question.reply', $question->id)); ?>"
                                    class="replay-form" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <textarea onclick="toggleEditor('<?php echo e($question->id); ?>')" placeholder="Add reply" class="form-control default-textarea-<?php echo e($question->id); ?>"></textarea>
                                    <div class="text-editor-<?php echo e($question->id); ?> d-none">
                                        <textarea name="reply" placeholder="Add reply" class="text-editor-img"></textarea>
                                        <button type="submit" class="btn mt-3 mb-3 ms-3"><?php echo e(__('submit')); ?></button>
                                        <button type="button" class="btn btn-two mt-3 mb-3 ms-3" onclick="toggleEditor('<?php echo e($question->id); ?>')"><?php echo e(__('Close')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-center"><?php echo e(__('No questions found!')); ?></p>
            <?php endif; ?>
            <?php echo e($lesson_questions?->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('frontend/js/default/instructor-qna.js')); ?>?v=<?php echo e($setting?->version); ?>"></script>
    <script>
        var isDemo = "<?php echo e(env('PROJECT_MODE') ?? 'LIVE'); ?>";
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.instructor-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\lesson-qna\index.blade.php ENDPATH**/ ?>