<?php $__env->startSection('contents'); ?>
    <section class="wsus__course_video">
        <div class="col-12">
            <div class="wsus__course_header">
                <?php if(Session::has('course_slug')): ?>
                    <a href="<?php echo e(route('student.learning.index', Session::get('course_slug'))); ?>"><i
                            class="fas fa-angle-left"></i><?php echo e(truncate(Session::get('course_title'))); ?></a>
                <?php endif; ?>
            </div>
        </div>

        <div class="container">
            <div class="question-container">
                <div class="row">
                    <div class="col-12 mb-5">
                        <div class="card">
                            <div class="card-body text-center">
                                <?php if($quizResult->status == 'pass'): ?>
                                    <div class="info-col text-center">
                                        <img src="<?php echo e(asset('uploads/website-images/good-score.png')); ?>">
                                    </div>
                                    <h5 class="card-title count"><?php echo e(__('You have passed the quiz!')); ?></h5>
                                <?php else: ?>
                                    <div class="info-col text-center">
                                        <img src="<?php echo e(asset('uploads/website-images/bad-score.png')); ?>">
                                    </div>
                                    <h5 class="card-title count"><?php echo e(__('You have failed the quiz!')); ?></h5>
                                    <span><?php echo e(__('Sorry you have failed the quiz better luck next time.')); ?></span>
                                <?php endif; ?>

                                <div class="mt-3 mb-3">
                                    <?php if(Session::has('course_slug')): ?>
                                        <a href="<?php echo e(route('student.learning.index', Session::get('course_slug'))); ?>"
                                            class="btn"><?php echo e(__('Go back to course page')); ?></a>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('student.enrolled-courses')); ?>"
                                            class="btn"><?php echo e(__('Go back to Dashboard')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <div class="card text-center">
                            <div class="info-col text-center">
                                <img src="<?php echo e(asset('uploads/website-images/student-grades.png')); ?>">
                            </div>
                            <div class="card-body">
                                <h6 class="card-title count"><?php echo e($quiz->pass_mark); ?>/<?php echo e($quiz->total_mark); ?></h6>
                                <p class="card-text"><?php echo e(__('Minimum Marks')); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-3">
                        <div class="card text-center">
                            <div class="info-col text-center">
                                <img src="<?php echo e(asset('uploads/website-images/test.png')); ?>">
                            </div>
                            <div class="card-body">
                                <h6 class="card-title count"><?php echo e($attempt); ?>/<?php echo e($quiz->attempt); ?></h6>
                                <p class="card-text"><?php echo e(__('Attempts')); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-3">
                        <div class="card text-center">
                            <div class="info-col text-center">
                                <img src="<?php echo e(asset('uploads/website-images/mark.png')); ?>">
                            </div>
                            <div class="card-body">
                                <h6 class="card-title count"><?php echo e($quizResult->user_grade); ?></h6>
                                <p class="card-text"><?php echo e(__('Your Marks')); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-3">
                        <div class="card text-center">
                            <div class="info-col text-center">
                                <img src="<?php echo e(asset('uploads/website-images/trophy.png')); ?>">
                            </div>
                            <div class="card-body">
                                <h6
                                    class="card-title count text-capitalize <?php echo e($quizResult->status == 'pass' ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e($quizResult->status == 'pass' ? __('Passed') : __('Failed')); ?></h6>
                                <p class="card-text"><?php echo e(__('Result')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <form action="<?php echo e(route('student.quiz.store', request('id'))); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <?php
                            $result = json_decode($quizResult->result);
                        ?>
                        <?php $__currentLoopData = $quiz->questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="question-box mt-4">
                                <h6><?php echo e($loop->iteration); ?>. <?php echo e($question->title); ?></h6>
                                <div class="row">
                                    <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6">
                                            <div
                                                class="card ans-body m-2 <?php echo e($answer->correct == 1 ? 'correct-ans' : 'wrong-ans'); ?>">
                                                <label for="ans-<?php echo e($answer->id); ?>" class="box first">
                                                    <div class="course">
                                                        <span class="circle">
                                                            <input disabled type="radio" <?php if(@$result?->{$question->id}?->answer == $answer->id): echo 'checked'; endif; ?>
                                                                name="question[<?php echo e($question->id); ?>]"
                                                                id="ans-<?php echo e($answer->id); ?>" value="<?php echo e($answer->id); ?>">
                                                        </span>
                                                        <span class="subject"><?php echo e($answer->title); ?></span>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </form>
            </div>
        </div>

    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('frontend/js/default/quiz-page.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            // reset quiz timer
            resetCountdown();
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.pages.learning-player.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\pages\learning-player\quiz-result.blade.php ENDPATH**/ ?>