<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Create Role')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.role.index')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Create Role')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a
                            href="<?php echo e(route('admin.role.index')); ?>"><?php echo e(__('Manage Roles')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Create Role')); ?></div>
                </div>
            </div>

            <div class="section-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Create Role')); ?></h4>
                                <div>
                                    <?php if(auth()->guard('admin')->user()->can('role.view')): ?>
                                        <a href="<?php echo e(route('admin.role.index')); ?>" class="btn btn-primary"><i
                                                class="fa fa-arrow-left"></i> <?php echo e(__('Back')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <form role="form" action="<?php echo e(route('admin.role.store')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <div class="card-body">
                                                <div class="form-group">
                                                    <label for="name"><?php echo e(__('Name')); ?></label>
                                                    <input name="name" type="text"
                                                        class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="role_name" placeholder="<?php echo e(__('Enter name')); ?>">
                                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="invalid-feedback"
                                                            role="alert"><strong><?php echo e($message); ?></strong></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                                <div class="form-group">
                                                    <label for="permission"><?php echo e(__('Permission')); ?></label>
                                                    <div class="custom-control custom-checkbox">
                                                        <input class="custom-control-input" type="checkbox"
                                                            id="permission_all" value="1">
                                                        <label for="permission_all"
                                                            class="custom-control-label permission_all"><?php echo e(__('All')); ?></label>
                                                    </div>
                                                    <hr>
                                                    <div class="admin_role_border">
                                                        <div class="row">
                                                            <?php $i=1; ?>
                                                            <?php $__currentLoopData = $permission_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="mb-2 col-lg-6 bottom-border">
                                                                    <div class="row">
                                                                        <div class="col-12 col-md-5 col-lg-5 col-xl-4 ">
                                                                            <div class="custom-control custom-checkbox">
                                                                                <input class="custom-control-input"
                                                                                    type="checkbox"
                                                                                    id="<?php echo e($i); ?>management"
                                                                                    onclick="CheckPermissionByGroup('role-<?php echo e($i); ?>-management-checkbox',this)"
                                                                                    value="2" name="permession_group">
                                                                                <label for="<?php echo e($i); ?>management"
                                                                                    class="custom-control-label text-capitalize"><?php echo e($group->name); ?></label>
                                                                            </div>
                                                                        </div>
                                                                        <div
                                                                            class="col-12 col-md-7 col-lg-7 col-xl-8 role-<?php echo e($i); ?>-management-checkbox">
                                                                            <?php
                                                                                $permissionss = App\Models\Admin::getpermissionsByGroupName(
                                                                                    $group->name,
                                                                                );
                                                                                $j = 1;
                                                                            ?>
                                                                            <?php $__currentLoopData = $permissionss; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input name="permissions[]"
                                                                                        class="custom-control-input"
                                                                                        type="checkbox"
                                                                                        id="permission_checkbox_<?php echo e($permission->id); ?>"
                                                                                        value="<?php echo e($permission->name); ?>"
                                                                                        data-role-id="<?php echo e($i); ?>">
                                                                                    <label
                                                                                        for="permission_checkbox_<?php echo e($permission->id); ?>"
                                                                                        class="custom-control-label"><?php echo e(implode(' ', array_map('ucfirst', explode('.', $permission->name)))); ?></label>
                                                                                </div>
                                                                                <?php $j++; ?>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <?php $i++; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="text-center col-md-8 offset-md-2">
                                                    <?php if (isset($component)) { $__componentOriginal42eb0eb0445477e4b420137b90787aa6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42eb0eb0445477e4b420137b90787aa6 = $attributes; } ?>
<?php $component = App\View\Components\Admin\SaveButton::resolve(['text' => __('Save')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.save-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\SaveButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $attributes = $__attributesOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $component = $__componentOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__componentOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict"

        function permission_all_checked() {
            var allCheckboxesChecked = $('input[type=checkbox]').not('#permission_all').length ===
                $('input[type=checkbox]:checked').not('#permission_all').length;
            $('#permission_all').prop('checked', allCheckboxesChecked);
        }

        $('input[name^="permession_group"]').on('change', function() {
            permission_all_checked();
        });

        $('#permission_all').on('click', function() {
            $('input[type=checkbox]').prop('checked', $(this).prop('checked'));
        });

        function CheckPermissionByGroup(classname, checkthis) {
            const groupIdName = $("#" + checkthis.id);
            const classCheckBox = $('.' + classname + ' input');

            classCheckBox.prop('checked', groupIdName.prop('checked'));
        }

        $('input[name^="permissions"]').on('change', function() {
            const roleId = $(this).data('role-id');
            const groupCheckbox = $('#' + roleId + 'management');
            const groupPermissions = $('input[name^="permissions"][data-role-id="' + roleId + '"]');

            const checkedPermissionsCount = groupPermissions.filter(':checked').length;
            const totalPermissionsCount = groupPermissions.length;

            groupCheckbox.prop('checked', checkedPermissionsCount === totalPermissionsCount);

            permission_all_checked();
        });
    </script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .bottom-border {
            border-bottom: 1px solid rgb(56, 53, 53);
        }
    </style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\admin\roles\create.blade.php ENDPATH**/ ?>