<?php
    $method = $paymentMethod;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Offline Payment</title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset($setting->favicon)); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/main.min.css')); ?>?v=<?php echo e($setting?->version); ?>">
</head>

<body>
    <section class="about-area-three section-py-120 vh-100 d-flex align-items-center justify-content-center">
        <div class="container d-flex justify-content-center">
            <div class="col-md-6">
                <div class="text-center mb-3">
                    <a href="<?php echo e(route('home')); ?>">
                        <img src="<?php echo e(asset($setting?->logo)); ?>" alt="<?php echo e($setting?->app_name); ?>" width="220">
                    </a>
                </div>
                <div class="card singUp-wrap">
                    <div class="card-body">
                        <form
                            action="<?php echo e(isset($token) ? route('payment-api.offline-webview', ['bearer_token' => $token, 'order_id' => $order_id]) : route('pay-via-offline')); ?>"
                            method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="branch"><?php echo e(__('Payment Receipt')); ?> <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="payment_receipt">
                                <?php $__errorArgs = ['payment_receipt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="text-center">
                                <button class="mt-2 btn btn-primary"><?php echo e(__('Submit Payment Receipt')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</body>

</html>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\gateway-actions\offline.blade.php ENDPATH**/ ?>